const User = require('./User');
const Contract = require('./Contract');
const Scene = require('./Scene');
const Settings = require('./Settings');

// Define associations
User.hasMany(Contract, { 
  foreignKey: 'createdBy', 
  as: 'createdContracts' 
});

User.hasMany(Contract, { 
  foreignKey: 'updatedBy', 
  as: 'updatedContracts' 
});

Contract.belongsTo(User, { 
  foreignKey: 'createdBy', 
  as: 'creator' 
});

Contract.belongsTo(User, { 
  foreignKey: 'updatedBy', 
  as: 'updater' 
});

Contract.hasMany(Scene, { 
  foreignKey: 'contractId', 
  as: 'scenes',
  onDelete: 'SET NULL'
});

Scene.belongsTo(Contract, { 
  foreignKey: 'contractId', 
  as: 'contract',
  allowNull: true
});

User.hasMany(Scene, { 
  foreignKey: 'createdBy', 
  as: 'createdScenes' 
});

User.hasMany(Scene, { 
  foreignKey: 'updatedBy', 
  as: 'updatedScenes' 
});

Scene.belongsTo(User, { 
  foreignKey: 'createdBy', 
  as: 'creator' 
});

Scene.belongsTo(User, { 
  foreignKey: 'updatedBy', 
  as: 'updater' 
});

Settings.belongsTo(User, { 
  foreignKey: 'updatedBy', 
  as: 'updater' 
});

module.exports = {
  User,
  Contract,
  Scene,
  Settings
};
