# نظام إدارة عقود الصيانة

نظام شامل لإدارة عقود الصيانة والمشاهد (الزيارات) المرتبطة بها، مصمم خصيصاً للشركات التي تقدم خدمات الصيانة.

## المميزات الرئيسية

### 🔐 إدارة المستخدمين والصلاحيات
- نظام مصادقة آمن مع JWT
- أنواع مستخدمين: مدير ومدخل بيانات
- صلاحيات مفصلة لكل مستخدم (إضافة، تعديل، عرض، حذف، طباعة)

### 📋 إدارة العقود
- إنشاء وتعديل وحذف العقود
- تتبع تفاصيل العقد الكاملة (الطرف الثاني، الموقع، المالك، الكاميرات، إلخ)
- رفع وإدارة المرفقات
- ترقيم تلقائي للعقود مع إمكانية التخصيص
- حالات العقود (نشط، منتهي، ملغي)

### 🔧 إدارة المشاهد (الزيارات)
- تسجيل زيارات الصيانة والتركيب
- تتبع تفاصيل العمل والمواد المستخدمة
- إدارة حالات المشاهد (معلق، قيد التنفيذ، مكتمل، ملغي)
- ربط المشاهد بالعقود

### 📊 التقارير والإحصائيات
- لوحة تحكم تفاعلية مع الإحصائيات
- تقارير مفصلة للعقود والمشاهد
- تصدير PDF و Excel
- تقارير زمنية (يومية، أسبوعية، شهرية، ربع سنوية، سنوية)
- تقارير مخصصة لفترات زمنية محددة

### 🖨️ إدارة الطباعة
- قوالب طباعة قابلة للتخصيص
- إعدادات الهوامش والرأس والتذييل
- طباعة جماعية للتقارير
- دعم اللغة العربية والتخطيط من اليمين لليسار

### 💾 النسخ الاحتياطي
- نسخ احتياطي تلقائي مجدول
- تحميل واستعادة النسخ الاحتياطية
- إدارة مدة الاحتفاظ بالنسخ
- تنظيف النسخ القديمة تلقائياً

### 🔍 البحث والتصفية
- بحث متقدم في العقود والمشاهد
- تصفية حسب التاريخ والحالة والنوع
- ترقيم الصفحات والتنقل السهل

## المتطلبات التقنية

### الخادم
- Node.js 16+ 
- MySQL 8.0+
- npm أو yarn

### المتصفح
- Chrome 90+
- Firefox 88+
- Safari 14+
- Edge 90+

## التثبيت والإعداد

### 1. تحميل المشروع
```bash
git clone <repository-url>
cd contracts_scenes
```

### 2. تثبيت التبعيات
```bash
npm install
```

### 3. إعداد قاعدة البيانات
قم بإنشاء قاعدة بيانات MySQL جديدة:
```sql
CREATE DATABASE contracts_maintenance CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 4. إعداد متغيرات البيئة
انسخ ملف `.env` وقم بتعديل الإعدادات:
```bash
cp .env.example .env
```

قم بتعديل الإعدادات في ملف `.env`:
```env
# إعدادات الخادم
PORT=3000
NODE_ENV=development

# إعدادات قاعدة البيانات
DB_HOST=localhost
DB_PORT=3306
DB_NAME=contracts_maintenance
DB_USER=your_username
DB_PASSWORD=your_password

# إعدادات JWT
JWT_SECRET=your_super_secret_jwt_key_here
JWT_EXPIRES_IN=24h

# إعدادات رفع الملفات
MAX_FILE_SIZE=10485760
UPLOAD_PATH=./uploads

# إعدادات النسخ الاحتياطي
BACKUP_PATH=./backups
BACKUP_SCHEDULE=0 2 * * *

# إعدادات الطباعة
PRINT_HEADER=نظام إدارة عقود الصيانة
PRINT_FOOTER=جميع الحقوق محفوظة
```

### 5. تهيئة قاعدة البيانات
```bash
# تهيئة قاعدة البيانات مع البيانات الأساسية
node scripts/init-db.js

# أو مع بيانات تجريبية
node scripts/init-db.js --sample-data
```

### 6. تشغيل الخادم
```bash
# للتطوير
npm run dev

# للإنتاج
npm start
```

الآن يمكنك الوصول للنظام على: `http://localhost:3000`

## معلومات تسجيل الدخول الافتراضية

**المدير:**
- اسم المستخدم: `admin`
- كلمة المرور: `admin123`

⚠️ **مهم:** يرجى تغيير كلمة المرور فور تسجيل الدخول الأول!

## هيكل المشروع

```
contracts_scenes/
├── config/              # إعدادات قاعدة البيانات
├── middleware/          # وسطاء Express
├── models/              # نماذج قاعدة البيانات
├── routes/              # مسارات API
├── scripts/             # سكريبتات المساعدة
├── public/              # الملفات الثابتة
│   ├── css/            # ملفات التنسيق
│   ├── js/             # ملفات JavaScript
│   └── index.html      # الصفحة الرئيسية
├── uploads/             # الملفات المرفوعة
├── backups/             # النسخ الاحتياطية
├── server.js            # ملف الخادم الرئيسي
├── package.json         # تبعيات المشروع
└── README.md           # هذا الملف
```

## API Documentation

### المصادقة
- `POST /api/auth/login` - تسجيل الدخول
- `GET /api/auth/me` - الحصول على بيانات المستخدم الحالي
- `PUT /api/auth/change-password` - تغيير كلمة المرور
- `POST /api/auth/logout` - تسجيل الخروج

### المستخدمين (مدير فقط)
- `GET /api/users` - قائمة المستخدمين
- `POST /api/users` - إنشاء مستخدم جديد
- `GET /api/users/:id` - تفاصيل مستخدم
- `PUT /api/users/:id` - تحديث مستخدم
- `DELETE /api/users/:id` - حذف مستخدم

### العقود
- `GET /api/contracts` - قائمة العقود
- `POST /api/contracts` - إنشاء عقد جديد
- `GET /api/contracts/:id` - تفاصيل عقد
- `PUT /api/contracts/:id` - تحديث عقد
- `DELETE /api/contracts/:id` - حذف عقد

### المشاهد
- `GET /api/scenes` - قائمة المشاهد
- `POST /api/scenes` - إنشاء مشهد جديد
- `GET /api/scenes/:id` - تفاصيل مشهد
- `PUT /api/scenes/:id` - تحديث مشهد
- `DELETE /api/scenes/:id` - حذف مشهد

### التقارير
- `GET /api/reports/dashboard` - إحصائيات لوحة التحكم
- `GET /api/reports/contract/:id` - تقرير عقد
- `GET /api/reports/scene/:id` - تقرير مشهد
- `GET /api/reports/time-range` - تقارير زمنية

### الإعدادات (مدير فقط)
- `GET /api/settings` - قائمة الإعدادات
- `PUT /api/settings/:key` - تحديث إعداد
- `POST /api/settings/initialize` - تهيئة الإعدادات الافتراضية

### النسخ الاحتياطي (مدير فقط)
- `GET /api/backup/list` - قائمة النسخ الاحتياطية
- `POST /api/backup/create` - إنشاء نسخة احتياطية
- `GET /api/backup/download/:filename` - تحميل نسخة احتياطية
- `DELETE /api/backup/:filename` - حذف نسخة احتياطية

## الأمان

### الحماية المطبقة
- تشفير كلمات المرور باستخدام bcrypt
- مصادقة JWT مع انتهاء صلاحية
- حماية من CSRF
- تحديد معدل الطلبات
- تنظيف البيانات المدخلة
- حماية الرؤوس مع Helmet

### أفضل الممارسات
- استخدم كلمات مرور قوية
- غيّر JWT_SECRET في الإنتاج
- فعّل HTTPS في الإنتاج
- قم بالنسخ الاحتياطي بانتظام
- راقب سجلات النظام

## استكشاف الأخطاء

### مشاكل شائعة

**خطأ في الاتصال بقاعدة البيانات:**
- تأكد من تشغيل MySQL
- تحقق من إعدادات الاتصال في `.env`
- تأكد من وجود قاعدة البيانات

**خطأ في رفع الملفات:**
- تحقق من صلاحيات مجلد `uploads`
- تأكد من حجم الملف أقل من الحد المسموح

**مشاكل في النسخ الاحتياطي:**
- تأكد من تثبيت `mysqldump`
- تحقق من صلاحيات مجلد `backups`

### السجلات
- سجلات الخادم: وحدة التحكم
- سجلات قاعدة البيانات: إعدادات Sequelize
- سجلات الأخطاء: ملفات السجل في مجلد `logs`

## المساهمة

نرحب بالمساهمات! يرجى:
1. عمل Fork للمشروع
2. إنشاء فرع للميزة الجديدة
3. كتابة الاختبارات
4. إرسال Pull Request

## الترخيص

هذا المشروع مرخص تحت رخصة MIT - انظر ملف [LICENSE](LICENSE) للتفاصيل.

## الدعم

للحصول على الدعم:
- افتح Issue في GitHub
- راسلنا على البريد الإلكتروني
- راجع الوثائق

## التحديثات المستقبلية

### الميزات المخططة
- [ ] تطبيق الهاتف المحمول
- [ ] إشعارات البريد الإلكتروني
- [ ] تكامل مع أنظمة CRM
- [ ] تقارير متقدمة مع الرسوم البيانية
- [ ] نظام المهام والتذكيرات
- [ ] API للتكامل مع أنظمة أخرى

### سجل التغييرات

#### الإصدار 1.0.0
- الإصدار الأولي
- جميع الميزات الأساسية
- واجهة المستخدم العربية
- نظام التقارير والطباعة
- النسخ الاحتياطي التلقائي

---

**تم تطوير هذا النظام بعناية لتلبية احتياجات شركات الصيانة في المنطقة العربية**
