const mysql = require('mysql2/promise');
const fs = require('fs').promises;
const path = require('path');
require('dotenv').config();

async function runMigration() {
  const connection = await mysql.createConnection({
    host: process.env.DB_HOST || 'localhost',
    user: process.env.DB_USER || 'root',
    password: process.env.DB_PASSWORD || '',
    database: process.env.DB_NAME || 'contracts_db',
    multipleStatements: true
  });

  try {
    console.log('Running migration 002: Remove scene fields...');
    
    // Read the migration file
    const migrationPath = path.join(__dirname, '002_remove_scene_fields.sql');
    const migrationSQL = await fs.readFile(migrationPath, 'utf8');
    
    // Execute the migration
    await connection.execute(migrationSQL);
    
    console.log('Migration 002 completed successfully!');
    console.log('Removed fields: technician, startTime, endTime, workDescription from scenes table');
    
  } catch (error) {
    console.error('Migration failed:', error);
    process.exit(1);
  } finally {
    await connection.end();
  }
}

runMigration();
